var that = this;
function __skpm_run (key, context) {
  that.context = context;

var exports =
/******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, {
/******/ 				configurable: false,
/******/ 				enumerable: true,
/******/ 				get: getter
/******/ 			});
/******/ 		}
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = 2);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ (function(module, exports) {

module.exports = require("sketch/dom");

/***/ }),
/* 1 */
/***/ (function(module, exports) {


var $ = {
  forEach: function () {
    function forEach(collection, iterator) {
      for (var i = 0; i < collection.count(); i++) {
        var item = collection.objectAtIndex(i);
        var returnValue = iterator(item, i, collection);
        if (returnValue === false) {
          break;
        }
      }
    }

    return forEach;
  }(),

  map: function () {
    function map(collection, transform) {
      var result = [];
      $.forEach(collection, function (item, i, collection) {
        result.push(transform(item, i, collection));
      });
      return result;
    }

    return map;
  }(),

  mapObject: function () {
    function mapObject(collection, transform) {
      var results = {};
      $.forEach(collection, function (item, i, collection) {
        var result = transform(item, i, collection);
        var key = result[0];
        var value = result[1];
        results[key] = value;
      });
      return results;
    }

    return mapObject;
  }(),

  find: function () {
    function find(collection, predicate) {
      var result;
      $.forEach(collection, function (item, i, collection) {
        if (predicate(item, i, collection)) {
          result = item;
          return false;
        }
      });
      return result;
    }

    return find;
  }()
};

module.exports = $;

/***/ }),
/* 2 */
/***/ (function(module, exports, __webpack_require__) {

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

exports['default'] = function (context) {

  pluginContext = context;

  var identifier = 'mockplusDesignSystem';
  var mainThread = NSThread.mainThread();
  var threadDictionary = mainThread.threadDictionary();

  if (threadDictionary[identifier]
  // `isOpened` doesn't exist after plugin update
  // while plugin thread is still running for unknown reason.
  // The same thread bug happens even after launching Cococa `Hello World` script
  && threadDictionary[identifier].panel.hasOwnProperty('isOpened') && threadDictionary[identifier].panel.isOpened) {
    var thread = threadDictionary[identifier];
    thread.close();
  } else {

    var delegateListeners = {
      "webView:didFinishLoadForFrame:": function () {
        function webViewDidFinishLoadForFrame(webView, webFrame) {

          var windowObject = webView.windowScriptObject();

          var currentVersion = '1.0.1';
          var skipVersion = persist.get("skipVersion");
          var userStr = persist.get("user");
          var catIndex = persist.get("selectedCatIndex");
          var libId = persist.get("selectedLibId");
          var libsStr = persist.get("libs");
          var libs = [];
          if (!isEmptyLocalData(libsStr)) {
            libs = JSON.parse(libsStr);
          }

          var resources = [];
          libs.forEach(function (lib) {
            var libStr = persist.get(lib.id);
            if (isEmptyLocalData(libStr)) {
              // log("passed ......");
            } else {
              var obj = JSON.parse(libStr);
              if ((typeof obj === 'undefined' ? 'undefined' : _typeof(obj)) === 'object' && Array.isArray(obj)) {
                obj.forEach(function (res) {
                  resources.push(res);
                });
              }
            }
          });

          var data = {
            clientType: 'Sketch',
            currentVersion: currentVersion,
            skipVersion: isEmptyLocalData(skipVersion) ? '' : skipVersion,
            user: isEmptyLocalData(userStr) ? {} : JSON.parse(userStr),
            libs: libs,
            resources: resources,
            selectedLibId: isEmptyLocalData(libId) ? '' : libId,
            catIndex: isEmptyLocalData(catIndex) ? '0' : catIndex
          };
          log(userStr);
          var script = "window.registInitData(" + JSON.stringify(data) + ");";
          // log(script);
          windowObject.evaluateWebScript(script);
        }

        return webViewDidFinishLoadForFrame;
      }(),
      "webView:didChangeLocationWithinPageForFrame:": function () {
        function webViewDidChangeLocationWithinPageForFrame(webView, webFrame) {
          // var panel = webView.superview().window();

          var windowObject = webView.windowScriptObject();
          var str = windowObject.valueForKey("data");
          // log(str);
          var response = JSON.parse(str);
          var action = response.eventName;

          var actions = {

            applyResToClient: function () {
              function applyResToClient() {
                var type = response.type;
                var data = response.data;
                if (type === 'color') {
                  aplayColorToLayers(data);
                } else if (type === 'fontStyle') {
                  aplayTextToLayers(data);
                }
              }

              return applyResToClient;
            }(),
            dropDataToClient: function () {
              function dropDataToClient() {

                if (response.type === 'fontStyle') {
                  dragTextToClient(response.data);
                } else if (response.type === 'component') {
                  dragCompToClient(response.data);
                }
              }

              return dropDataToClient;
            }(),
            addResFromClient: function () {
              function addResFromClient() {
                var type = response.type;
                if (type === 'color') {
                  var data = JSON.stringify(onAddColors());
                  var script = "window.renderColorForm('" + data + "', '" + response.sectionID + "')";
                  windowObject.evaluateWebScript(script);
                } else if (type === 'fontStyle') {
                  var data = JSON.stringify({
                    data: onAddTextStyle(),
                    sectionID: response.sectionID
                  });
                  var script = "window.addResToServer('" + data + "', '" + response.sectionID + "')";
                  windowObject.evaluateWebScript(script);
                } else if (type === 'component') {
                  onAddComponent(function (componentInfo) {
                    var data = JSON.stringify({
                      data: componentInfo,
                      sectionID: response.sectionID
                    });
                    var script = "window.addResToServer('" + data + "', '" + response.sectionID + "')";
                    windowObject.evaluateWebScript(script);
                  });
                } else {
                  onAddImage(function (fileInfo) {
                    var data = JSON.stringify({
                      data: fileInfo,
                      sectionID: response.sectionID
                    });
                    var script = "window.addResToServer('" + data + "', '" + response.sectionID + "')";
                    windowObject.evaluateWebScript(script);
                  });
                }
              }

              return addResFromClient;
            }(),
            addSection: function () {
              function addSection() {
                var sectionName = onAddPalette();
                var data = JSON.stringify({
                  sectionName: sectionName,
                  type: response.type
                });
                var script = "window.addSectionToServer('" + data + "')";
                windowObject.evaluateWebScript(script);
              }

              return addSection;
            }(),
            // logined: function() {
            //   var data = response.data;
            //   persist.set("email", data.email);
            //   persist.set("password", data.password);
            // },
            logout: function () {
              function logout() {
                log("logout-----");
                //persist.remove('hasLogged');
                persist.remove("user");
                persist.remove("libs");
              }

              return logout;
            }(),
            cancelLogin: function () {
              function cancelLogin() {
                var thread = threadDictionary[identifier];
                thread.close();
              }

              return cancelLogin;
            }(),
            openExternalLink: function () {
              function openExternalLink() {
                var data = response.data;
                if (data) {
                  skipToExternalLink(data.url);
                }
              }

              return openExternalLink;
            }(),
            cacheWebData: function () {
              function cacheWebData() {
                var data = response.data;
                if (data) {
                  // if (data.key === 'dieTest') {
                  //   log("debug: ===" + data.value + "====");
                  // }
                  persist.set(data.key, data.value);
                }
              }

              return cacheWebData;
            }()

          };

          if (typeof actions[action] === 'function') {
            actions[action]();
          }
        }

        return webViewDidChangeLocationWithinPageForFrame;
      }()

    };

    if (threadDictionary[identifier]) {
      threadDictionary.removeObjectForKey(identifier);
    }

    var timestamp = Date.now();
    // var url = encodeURI('http://192.168.1.107:3000#' + timestamp);
    var resourcePath = pluginContext.plugin.urlForResourceNamed("html/index.html").path();
    var url = encodeURI('file://' + resourcePath + '#' + timestamp);
    var webUI = new WebUI(context, url, {
      identifier: identifier, // to reuse the UI
      x: 0,
      y: 0,
      width: 360,
      height: 640,
      blurredBackground: true,
      background: NSColorFromString('#fbfbf9'),
      onlyShowCloseButton: true,
      title: 'Mockplus设计系统',
      hideTitleBar: false,
      shouldKeepAround: true,
      resizable: false,
      uiDelegate: {},
      handlers: delegateListeners

    });
  }
};

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }

var sketch = __webpack_require__(3);
var UI = __webpack_require__(4);
var Document = __webpack_require__(0).Document;
var Dom = __webpack_require__(0);
var Style = Dom.Style;
var Text = Dom.Text;
var Rectange = Dom.Rectangle;

var document = Document.getSelectedDocument();
var selection = document.selectedLayers;

var pluginContext;
var panel;
var webView;

var MochaJSDelegate = __webpack_require__(5);
var persist = __webpack_require__(6);
var archive = __webpack_require__(7);
var $ = __webpack_require__(1);

var WebUI = __webpack_require__(8);

/**
 * begin ++++++++++++++++++++++++++++
 * 1、网页端触发的事件处理
 */

function dragTextToClient(data) {
  var droppedLayer = null;

  if (selection.layers && selection.layers.length === 1) {
    droppedLayer = selection.layers[0];
  }

  //拖拽进入sketch的文本图层名为'...'，这是约定的名称
  if (droppedLayer) {
    var oldW = droppedLayer.frame.width;
    var oldH = droppedLayer.frame.height;

    droppedLayer.text = data.text || '';

    var textStyle = aplayTextStyleToSketch(data);
    droppedLayer.sketchObject.style().setTextStyle(textStyle);

    droppedLayer.adjustToFit();
    droppedLayer.fixedWidth = false;

    var newW = droppedLayer.frame.width;
    var newH = droppedLayer.frame.height;

    droppedLayer.frame = droppedLayer.frame.offset((oldW - newW) / 2, (oldH - newH) / 2);
  }
}

function dragImgToClient(data) {
  var droppedLayer = null;

  if (selection.layers && selection.layers.length === 1) {
    droppedLayer = selection.layers[0];
  }

  //拖拽进入sketch的文本图层名为'...'，这是约定的名称
  if (droppedLayer) {

    var oldX = droppedLayer.frame.x;
    var oldY = droppedLayer.frame.y;
    var oldW = droppedLayer.frame.width;
    var oldH = droppedLayer.frame.height;

    var dropParent = getParentLayer(droppedLayer.sketchObject);
    dropParent.removeLayer(droppedLayer);

    // Load the image.
    var bitmapLayer = importImage(data.url, data.extension || 'png');

    if (bitmapLayer) {
      // Add image layer to document.
      dropParent.addLayer(bitmapLayer);

      bitmapLayer.setName(data.name);

      // Select the added layer, which mimicks the
      // behavior of dragged in layers.
      bitmapLayer.select_byExpandingSelection(true, false);

      var newW = data.w;
      var newH = data.h;

      bitmapLayer.frame = new Rectange(oldX + (oldW - newW) / 2, oldY + (oldH - newH) / 2, newW, newH);
    }
  }
}

function dragCompToClient(data) {

  var droppedLayer = null;
  var document = MSDocument.currentDocument();
  var layers = selectedLayersInDocument(document);

  if (layers && layers.length === 1) {
    droppedLayer = layers[0];
  }

  if (data.fileURL && data.source === 'sketch' && droppedLayer) {

    var pasteboardLayers = loadSketchLayers(data);
    if (!pasteboardLayers) {
      return;
    }

    var dropParent = getParentLayer(droppedLayer);
    var targetX = droppedLayer.frame().x();
    var targetY = droppedLayer.frame().y();

    dropParent.removeLayer(droppedLayer);

    var layerToAdd = pasteboardLayers.layers().firstLayer();

    // Give layer trees all new objectIDs so there are
    // no objectID duplicates in the document.
    $.forEach(layerToAdd.children(), function (layer) {
      layer.setObjectID(MSModelObjectCommon.generateObjectID());
    });

    // Add layer to document.
    dropParent.addLayer(layerToAdd);
    layerToAdd.frame().setX(targetX);
    layerToAdd.frame().setY(targetY);

    // If the layer is dropped inside an artboard, but
    // ends up outside the bounds of the artboard, move
    // it up to the page level.
    var artboard = layerToAdd.parentArtboard();
    if (artboard && layerToAdd !== artboard) {
      var artboardSize = artboard.frame().rect().size;
      var relativeArtboardRect = CGRectMake(0, 0, artboardSize.width, artboardSize.height);

      if (!CGRectIntersectsRect(relativeArtboardRect, layerToAdd.frame().rect())) {
        var page = getParentLayer(dropParent, MSPage);
        layerToAdd.moveToLayer_beforeLayer(page, null);
      }
    }

    // Set the name of the added layer.
    layerToAdd.setName(data.name);

    // Select the added layer, which mimicks the
    // behavior of dragged in layers.
    layerToAdd.select_byExpandingSelection(true, false);
  }
}

function aplayColorToLayers(data) {
  var activeWindow = NSApplication.sharedApplication().mainWindow();
  if (activeWindow && activeWindow['class']() == 'MSDocumentWindow') {
    var _document = activeWindow.document();
    var _selection = selectedLayersInDocument(_document);
    _selection.forEach(function (layer) {
      //单独处理文本图层，设置文本颜色
      if (coerceString(layer['class']()) === 'MSTextLayer') {
        setTextColor(layer, data.fill || data.textColor);
      }

      if (!layer.style) {
        return;
      }

      if (data.shiftKey && data.fill) {
        setBorderColor(layer, data.fill || data.borderColor);
      } else if (data.borderColor) {
        setBorderColor(layer, data.borderColor);
      } else if (data.fill) {
        setFillColor(layer, data.fill);
      }
    });
    _document.reloadInspector();
  }
}

function setBorderColor(layer, color) {
  var borders = layer.style().borders();
  borders.forEach(function (border) {
    border.fillType = 0;
    border.color = rgbaToMSColor(color);
  });
}

function setFillColor(layer, color) {
  var fills = layer.style().fills();
  fills.forEach(function (fill) {
    fill.fillType = 0;
    fill.color = rgbaToMSColor(color);
  });
}

function setTextColor(layer, color) {
  if (color) {
    layer.textColor = rgbaToMSColor(color);
  }
}

function aplayTextToLayers(data) {
  for (var i = 0; i < selection.length; i++) {
    var layer = selection.layers[0];
    if (layer.type === 'Text') {
      var textStyle = aplayTextStyleToSketch(data);
      layer.sketchObject.style().setTextStyle(textStyle);
    }
  }
  var activeWindow = NSApplication.sharedApplication().mainWindow();
  if (activeWindow && activeWindow['class']() == 'MSDocumentWindow') {
    var _document2 = activeWindow.document();
    _document2.reloadInspector();
  }
}

//跳转到外部链接
function skipToExternalLink(url) {
  NSWorkspace.sharedWorkspace().openURL(NSURL.URLWithString(url));
}

function onAddColors() {

  var document = MSDocument.currentDocument();
  var colorSections = [];

  //todo: filter existing colors in the library from this list?
  var msColors = getLayersColors(selectedLayersInDocument(document));
  msColors.forEach(function (msColor) {
    colorSections.push({
      value: stringForMSColor(msColor),
      type: 'selectedColor'
    });
  });

  var documentMSColors = document.documentData().assets().colors();
  documentMSColors.forEach(function (msColor) {
    colorSections.push({
      value: stringForMSColor(msColor),
      type: 'documentColor'
    });
  });

  var globalMSColors = NSApp.delegate().globalAssets().colors();
  globalMSColors.forEach(function (msColor) {
    colorSections.push({
      value: stringForMSColor(msColor),
      type: 'globalColor'
    });
  });

  return colorSections;
}

function onAddImage(cb) {
  var document = MSDocument.currentDocument();
  var layers = selectedLayersInDocument(document);
  var fileInfo = [];

  // var overCount = 0;
  // var uploadImgCallback = function(response) {
  //   overCount++;
  //
  //   if(response.payload) {
  //     fileInfo.push({
  //       //name: response.payload.name + '',
  //       //backgroundColor: 'rgba(255,0,0,1)',
  //       URL: response.payload.URL + '',
  //       extension: '.png',
  //       fileName: 'test'
  //     });
  //     if(overCount >= layers.length) {
  //       cb(fileInfo);
  //     }
  //   }
  //
  // };


  layers && layers.forEach && layers.forEach(function (layer) {

    // var filepath = exportLayerToTempFile(document, layer, "png");
    // uploadFile(filepath, uploadImgCallback);

    var fileData = exportLayerToTempFile(document, layer, "png");

    var d = dataURLFromData(fileData, 'image/png') + '';
    fileInfo.push({
      //name: response.payload.name + '',
      //backgroundColor: 'rgba(255,0,0,1)',
      imgData: d,
      extension: '.png',
      fileName: 'image.png',
      dimensions: {
        width: layer.frame().width(),
        height: layer.frame().height()
      }

    });
  });

  cb(fileInfo);
  // return fileInfo;
}

function onAddComponent(cb) {

  var document = MSDocument.currentDocument();
  var layers = selectedLayersInDocument(document);
  var componentInfo = [];

  layers && layers.forEach && layers.forEach(function (layer) {

    var fileData = exportLayerToTempFile(document, layer, "png");
    var d = dataURLFromData(fileData, 'image/png') + '';

    componentInfo.push({
      imgData: d,
      extension: '.skla',
      fileName: 'test',
      layerData: getLayerData(layer),
      dimensions: {
        width: layer.frame().width(),
        height: layer.frame().height()
      }
    });
  });

  cb(componentInfo);
}

function onAddPalette() {

  var newPaletteName = displayPrompt({
    title: 'New section name',
    defaultText: 'Untitled section',
    buttons: ['Add section', 'Cancel']
  });

  if (newPaletteName != null) {
    return newPaletteName + '';
  }

  return '';
};

function onAddTextStyle() {
  var textStyleSections = [];
  for (var i = 0; i < selection.length; i++) {

    var layer = selection.layers[0];
    if (layer.type === "Text" && layer._object.font()) {

      var textStyle = parseTextStyleFromSketch(layer.sketchObject.style().textStyle());
      textStyle.sampleText = layer.name;
      textStyleSections.push(textStyle);
    }
  }

  return textStyleSections;
}

/**
 * end -----------------------------
 * 1、网页端触发的事件处理
 */

/**
 * begin ++++++++++++++++++++++++++++
 * 2、处理文本样式相关
 */

//从sketch中获取文本相关属性转换为可供上传的数据
function parseTextStyleFromSketch(textStyle) {
  var textAttrs = textStyle.attributes();
  var font = textAttrs.NSFont;
  var paragraphStyle = textAttrs.NSParagraphStyle || NSParagraphStyle['new']();
  // const contextSettings = style.contextSettings && style.contextSettings();

  // Get the text color, which is in a different format depending on the version of Sketch.
  var color; // We want this to be an MSColor or MSImmutableColor
  if (textAttrs.MSAttributedStringColorAttribute) {
    // Sketch 38 and up.
    color = textAttrs.MSAttributedStringColorAttribute;
  } else {
    // Sketch up to 37.
    color = MSColor.colorWithNSColor(textAttrs.NSColor);
  }

  var alignmentMap = {};
  alignmentMap[NSTextAlignmentLeft] = 'left';
  alignmentMap[NSTextAlignmentRight] = 'right';
  alignmentMap[NSTextAlignmentCenter] = 'center';
  alignmentMap[NSTextAlignmentJustified] = 'left';
  alignmentMap[NSTextAlignmentNatural] = 'left';

  return {
    fontFamily: coerceString(font.familyName()),
    fontVariant: fontVariantFromNSFont(font),
    fontSize: font.pointSize(),
    textColor: stringForMSColor(color),
    sampleText: 'sample text',
    lineHeight: paragraphStyle.minimumLineHeight() || Math.ceil(font.pointSize() * 1.42),
    alignment: alignmentMap[paragraphStyle.alignment()] || 'left',
    underline: coerceBool(textAttrs.NSUnderline),
    strikeThrough: coerceBool(textAttrs.NSStrikethrough),
    uppercase: textAttrs.MSAttributedStringTextTransformAttribute == 1 ? true : false

    // letterSpacing:    coerceNumber(textAttrs.NSKern) || void 0,
    // paragraphSpacing: paragraphStyle.paragraphSpacing() || void 0,
    // lowercase:        textAttrs.MSAttributedStringTextTransformAttribute == 2 ? true : false,
    // opacity:          contextSettings ? coerceNumber(contextSettings.opacity()) : void 0,
    // metadata:         { postScriptName: coerceString(font.fontName()) }
  };
}

//将网页中传来的数据转换为文本的TextStyle
function aplayTextStyleToSketch(data) {
  var font = NSFontFromWebData(data);
  if (!font) {
    font = NSFont.fontWithName_size('Helvetica', data.fontSize);
  }
  var paragraphStyle = NSMutableParagraphStyle['new']();
  if (data.lineHeight) {
    var lh = data.lineHeight;
    if (data.fontSize && Math.ceil(data.fontSize * 1.42) > lh) {
      lh = Math.ceil(data.fontSize * 1.42);
    }
    paragraphStyle.minimumLineHeight = lh;
    paragraphStyle.maximumLineHeight = lh;
  }

  paragraphStyle.setAlignment({
    left: NSTextAlignmentLeft,
    right: NSTextAlignmentRight,
    center: NSTextAlignmentCenter
    // justify:    NSTextAlignmentJustified,
    // start:      NSTextAlignmentNatural
  }[data.textAlign] || NSTextAlignmentNatural);

  var newStyleAttrs = {
    NSColor: NSColorFromString(data.textColor),
    NSFont: font,
    NSParagraphStyle: paragraphStyle
  };

  if (data.underline) {
    newStyleAttrs.NSUnderline = NSUnderlineStyleSingle;
  }
  if (data.strikeThrough) {
    newStyleAttrs.NSStrikethrough = NSUnderlineStyleSingle;
  }
  if (data.uppercase) {
    newStyleAttrs.MSAttributedStringTextTransformAttribute = 1;
  }
  // else if (typeStyle.lowercase) {
  //   newStyleAttrs.MSAttributedStringTextTransformAttribute = 2;
  // }
  // if (typeStyle.letterSpacing) {
  //   newStyleAttrs.NSKern = typeStyle.letterSpacing;
  // }
  // if (data.paragraphSpacing) {
  //   paragraphStyle.paragraphSpacing = data.paragraphSpacing;
  // }


  return MSTextStyle.styleWithAttributes(newStyleAttrs);
}

//根据从网页上传过来的数据，创建NSFont对象
function NSFontFromWebData(data) {
  var result;

  // Look up font directly using PostScript name, if we have it.
  // if (typeStyle.metadata && typeStyle.metadata.postScriptName) {
  //   result = NSFontFromPostScriptName(typeStyle.metadata.postScriptName, typeStyle.fontSize);
  //   if (result) {
  //     return result;
  //   }
  // }

  if (!data.fontFamily) {
    return;
  }

  var fontManager = NSFontManager.sharedFontManager();
  var availableMembers = getAvailableMembersOfFontFamily(data.fontFamily);
  var fontMembers = availableMembers.members;
  var lookupFamilyName = availableMembers.familyName;

  var targetFVDWeight = parseInt((data.fontVariant || '')[1], 10) || 4;
  var targetFVDStyle = (data.fontVariant || '')[0] || 'n';
  var targetIsItalic = targetFVDStyle == 'i';
  var targetWeightName = namedWeightFromFVDWeight(targetFVDWeight);

  if (fontMembers) {
    fontMembers.forEach(function (member) {

      var psName = member.objectAtIndex(0);
      var appleWeight = member.objectAtIndex(2);
      var traits = member.objectAtIndex(3);
      var faceName = member.objectAtIndex(1); // E.g. 'Roman', 'Italic', etc.


      // Match with extrapolated FVD.
      var memberFVD = fontVariantFromFamilyMemberData(psName, appleWeight, traits);
      if (memberFVD == data.fontVariant) {
        result = NSFontFromPostScriptName(psName, data.fontSize);
        return false;
      }

      // Match with extrapolated weight name.
      var memberWeightName = faceName.split(' ')[0];
      var memberFaceIsItalic = isFontFaceItalic(traits, faceName);
      if (memberWeightName == targetWeightName && memberFaceIsItalic == targetIsItalic) {
        result = NSFontFromPostScriptName(psName, data.fontSize);
        return false;
      }
    });

    // Last resort: Get font based on generic mapping from FVD weight.
    if (!result) {
      result = fontManager.fontWithFamily_traits_weight_size(lookupFamilyName, targetFVDStyle === 'i' ? NSItalicFontMask : 0, appleWeightFromFVDWeight(targetFVDWeight), data.fontSize);
    }
  }

  return result;
}

function fontVariantFromNSFont(font) {
  var appleWeight = NSFontManager.sharedFontManager().weightOfFont(font);
  var traits = font.fontDescriptor().symbolicTraits();
  return fontVariantFromFamilyMemberData(font.fontName(), appleWeight, traits);
}

function fontVariantFromFamilyMemberData(psName, appleWeight, fontTraits) {
  appleWeight = overrideAppleFontWeight(psName) || appleWeight;
  var cssWeight = CSSWeightFromAppleWeight(appleWeight);
  var isItalic = isFontFaceItalic(fontTraits, psName);
  return (isItalic ? 'i' : 'n') + cssWeight;
}

function NSFontFromPostScriptName(psName, size) {
  // Look up font using PostScript name (which can only be done using a
  // NSFontDescriptor.
  var fontDescriptor = NSFontDescriptor.fontDescriptorWithFontAttributes({
    NSFontNameAttribute: psName
  });
  var result = fontDescriptor.matchingFontDescriptorWithMandatoryKeys(null);
  return NSFont.fontWithDescriptor_size(result, size);
}

function getAvailableMembersOfFontFamily(fontStack) {
  var fontManager = NSFontManager.sharedFontManager();

  // TODO: Go through the list of families in the stack?
  var family = getPrimaryFontFamily(fontStack);

  // Note: availableMembersOfFontFamily will return null if there are no matches.
  var members = fontManager.availableMembersOfFontFamily(family);

  if (!members) {
    var installedFamilies = fontManager.availableFontFamilies();
    var installedFamiliesKeyedBySimplifiedName = {};
    installedFamilies.forEach(function (family) {
      var simplifiedName = simplifyFontFamilyName(coerceString(family));
      installedFamiliesKeyedBySimplifiedName[simplifiedName] = family;
    });

    var simplifiedTargetName = simplifyFontFamilyName(family);
    var simplifiedMatch = installedFamiliesKeyedBySimplifiedName[simplifiedTargetName];
    if (simplifiedMatch) {
      members = fontManager.availableMembersOfFontFamily(simplifiedMatch);
      family = simplifiedMatch;
    }

    if (!members) {
      // Match families with a trailing single letter, e.g. 'Gotham A' which
      // are created by Typography.com.
      var modFamilyName = family.replace(new RegExp(' [A-Za-z]$'), '');
      var modSimplifiedTargetName = simplifyFontFamilyName(modFamilyName);
      var modSimplifiedMatch = installedFamiliesKeyedBySimplifiedName[modSimplifiedTargetName];
      if (modSimplifiedMatch) {
        members = fontManager.availableMembersOfFontFamily(modSimplifiedMatch);
        family = modSimplifiedMatch;
      }
    }
  }

  return {
    members: members,
    familyName: family
  };
}

function namedWeightFromFVDWeight(weight) {
  return ['', // 0 index; not used
  'Thin', // 1
  'Extra-Light', // 2
  'Light', // 3
  'Regular', // 4
  'Medium', // 5
  'Semi-Bold', // 6
  'Bold', // 7
  'Extra-Bold', // 8
  'Ultra-Bold' // 9
  ][weight];
}

function fontVariantFromFamilyMemberData(psName, appleWeight, fontTraits) {
  appleWeight = overrideAppleFontWeight(psName) || appleWeight;
  var cssWeight = CSSWeightFromAppleWeight(appleWeight);
  var isItalic = isFontFaceItalic(fontTraits, psName);
  return (isItalic ? 'i' : 'n') + cssWeight;
}

function isFontFaceItalic(fontTraits, faceName) {
  // Cocoa does not set the italic traits for HelveticaLightItalic and maybe
  // others. See Mozilla bug 611855. So we check the face name endings as
  // well as the trait.
  return fontTraits & NSItalicFontMask || faceName.hasSuffix('Italic') || faceName.hasSuffix('Oblique');
}

function getPrimaryFontFamily(fontStack) {
  fontStack = fontStack.replace(new RegExp('(^\\s+|\\s+$)', 'g'));

  var match = new RegExp('^"((\\\\"|[^"])+)"').exec(fontStack);
  if (match) {
    return match[1].replace(new RegExp('\\\\"', 'g'), '"');
  }

  match = new RegExp("^'((\\\\'|[^'])+)'").exec(fontStack);
  if (match) {
    return match[1].replace(new RegExp("\\\\'", 'g'), "'");
  }

  match = new RegExp('^(\\\\,|[^,])+').exec(fontStack);
  if (match) {
    return match[0];
  }
}

// 'Frutiger Neue LT Pro' => 'frutigerneueltpro'
// 'FrutigerNeueLTPro'    => 'frutigerneueltpro'
// 'museo-sans'           => 'museosans'
// 'Museo Sans'           => 'museosans'
function simplifyFontFamilyName(fontFamily) {
  return fontFamily.replace(new RegExp('[- ]', 'g'), '').toLowerCase();
}

// Special cases for known issues with fonts.
function overrideAppleFontWeight(psName) {
  switch (coerceString(psName)) {
    case 'HelveticaNeue-Thin':
    case 'HelveticaNeueLTPro-Th':
    case 'Oswald-ExtraLight':
    case 'Optimist-ExtraLight':
    case 'Optimist-ExtraLightItalic':
    case 'Mallory-ExtraLight':
    case 'Mallory-ExtraLightItalic':
      return 2;
  }

  if (psName.indexOf('-Book') > 0) {
    return 5;
  }
}

function CSSWeightFromAppleWeight(weight) {
  if (weight == 1) return 1;
  if (weight == 2) return 2;
  if (weight <= 4) return 3;
  if (weight == 5) return 4;
  if (weight == 6) return 5;
  if (weight <= 8) return 6;
  if (weight == 9) return 7;
  if (weight <= 11) return 8;
  return 9;
}

/**
 * end -----------------------------
 * 2、处理文本样式相关
 */

/**
 * begin ++++++++++++++++++++++++++++
 * 3、处理颜色相关
 */

//获取一组图层上的颜色数组
function getLayersColors(layers) {
  var colorsSet = NSMutableSet['new']();
  layers.forEach(function (layer) {
    var properties = colorPropertiesForLayer(layer);
    if (properties) {
      properties.forEach(function (property) {
        var color = getColorPropertyOnLayer(layer, property);
        if (color) {
          var hash = hashForMSColor(color);
          colorsSet.addObject(color);
        }
      });
    }
  });
  return colorsSet.allObjects();
}

//将msColor转换为十六进制颜色值
function hashForMSColor(msColor) {
  msColor = msColor.immutableModelObject();
  var hash = msColor.hexValue();
  if (msColor.alpha() != 1) {
    var alphaString = Math.floor(msColor.alpha() * 255).toString(16).toUpperCase();
    if (alphaString.length === 1) {
      alphaString = '0' + alphaString;
    }
    hash = hash + alphaString;
  }
  return hash;
}

function stringForMSColor(msColor) {
  msColor = msColor.immutableModelObject();

  var valuesString = [Math.round(msColor.red() * 255), Math.round(msColor.green() * 255), Math.round(msColor.blue() * 255)].join(', ');

  if (msColor.alpha() != 1) {
    return 'rgba(' + valuesString + ', ' + msColor.alpha().toString().substr(0, 5) + ')';
  } else {
    return 'rgb(' + valuesString + ')';
  }
}

function colorPropertiesForLayer(layer, preferBorders) {
  if (layer && layer['class']) {

    var borderPreferenceWeight = preferBorders ? 120 : 0;

    switch (coerceString(layer['class']())) {

      case 'MSTextLayer':
        return [{ property: 'textColor', weight: 5 }].concat(_toConsumableArray(fillColorPropertiesForLayer(layer, 0, function () {
          return 0;
        })), _toConsumableArray(borderColorPropertiesForLayer(layer, 0 + borderPreferenceWeight, function () {
          return 0 + borderPreferenceWeight;
        })));

      case 'MSShapeGroup':
        return [].concat(_toConsumableArray(fillColorPropertiesForLayer(layer, 0, function (fill, fillIdx, fills) {
          var weight = 10;
          if (fill.fillType() == 0) {
            weight += 10;
          }
          if (!fill.isEnabled()) {
            weight += -100;
          }
          weight += fillIdx / fills.count();
          return weight;
        })), _toConsumableArray(borderColorPropertiesForLayer(layer, -10 + borderPreferenceWeight, function (border, borderIdx, borders) {
          var weight = 0 + borderPreferenceWeight;
          if (border.fillType() == 0) {
            weight += 2;
          }
          if (!border.isEnabled()) {
            weight += -100;
          }
          weight += Math.min(border.thickness(), 100) / 100;
          weight += borderIdx / borders.count();
          return weight;
        })));
    }
  }
}

function fillColorPropertiesForLayer(layer, newFillWeight, weightForFill) {
  var properties = [];
  var fills = layer.style().fills();
  fills.forEach(function (fill, fillIdx) {
    properties.push({
      property: 'fill',
      weight: weightForFill(fill, fillIdx, fills),
      id: fill.objectID()
    });
  });
  if (properties.length == 0) {
    properties.push({
      property: 'newFill',
      weight: newFillWeight
    });
  }
  return properties;
}

function borderColorPropertiesForLayer(layer, newBorderWeight, weightForBorder) {
  var properties = [];
  var borders = layer.style().borders();
  borders.forEach(function (border, borderIdx) {
    properties.push({
      property: 'border',
      weight: weightForBorder(border, borderIdx, borders),
      id: border.objectID()
    });
  });
  if (properties.length == 0) {
    properties.push({
      property: 'newBorder',
      weight: newBorderWeight
    });
  }
  return properties;
}

//获取图层上的颜色属性值
function getColorPropertyOnLayer(layer, property) {
  switch (property.property) {
    case 'fill':
      var fill = getStyleById(layer.style().fills(), property.id);
      return fill ? fill.color() : void 0;

    case 'border':
      var border = getStyleById(layer.style().borders(), property.id);
      return border ? border.color() : void 0;

    case 'textColor':
      return layer.textColor();
  }
}

//将十六进制字符串转换为rgba对象
function hexToRgb(hex) {
  var result = /^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i.exec(hex);

  if (result) {
    result = {
      r: parseInt(result[1], 16),
      g: parseInt(result[2], 16),
      b: parseInt(result[3], 16)
    };
  } else {
    result = null;
  }

  return result;
}

//将rgba字符串转换为rgba对象
function rgbaStrToObj(str) {
  str = str.toUpperCase();
  if (/^(RGB|RGBA)/.test(str)) {
    var aColor = str.replace(/(?:\(|\)|RGBA|RGB)*/g, "").split(",");

    if (aColor.length >= 3) {
      return {
        r: parseInt(aColor[0], 10),
        g: parseInt(aColor[1], 10),
        b: parseInt(aColor[2], 10),
        a: parseInt(aColor[3] || 1, 10)
      };
    } else {
      return null;
    }
  }
}

//将十六进制字符串颜色转换为sketch中的MSColor对象
function hexToMSColor(hex) {
  var rgbObj = hexToRgb(hex);
  var red = rgbObj.r / 255;
  var green = rgbObj.g / 255;
  var blue = rgbObj.b / 255;
  return MSColor.colorWithRed_green_blue_alpha(red, green, blue, 1.0);
}

function rgbaToMSColor(rgbaStr) {

  var rgbaObj = rgbaStrToObj(rgbaStr);
  var red = rgbaObj.r / 255;
  var green = rgbaObj.g / 255;
  var blue = rgbaObj.b / 255;
  return MSColor.colorWithRed_green_blue_alpha(red, green, blue, rgbaObj.a || 1);
}

function MSColorFromString(string, immutableOnly) {
  if (/^(#|rgb\b)/.test(string)) {
    // Handle hex and rgb() formats.
    var immutableColorWithSVG = MSImmutableColor.colorWithSVGString(string);
    if (immutableOnly) {
      return immutableColorWithSVG;
    }
    return mutableSketchObject(immutableColorWithSVG);
  } else if (/[0-9a-f]{6}/i.test(string)) {
    var _immutableColorWithSVG = MSImmutableColor.colorWithSVGString('#' + string);
    if (immutableOnly) {
      return _immutableColorWithSVG;
    }
    // Handle hex colors without a leading # mark.
    return mutableSketchObject(_immutableColorWithSVG);
  } else {
    // Handle rgba() format, which is surprisingly not supported by Sketch’s
    // MSColor colorWithSVGString:
    var whitespace = '\\s*';
    var number = '(\\d+(\\.\\d+)?)'; // Note: surrounded by capture group.
    var comma = ',';
    var pattern = ['rgba\\(', whitespace, number, comma, whitespace, number, comma, whitespace, number, comma, whitespace, number, whitespace, '\\)'].join('');
    var match = new RegExp(pattern).exec(string);
    if (match) {
      var red = parseFloat(match[1]) / 255;
      var green = parseFloat(match[3]) / 255;
      var blue = parseFloat(match[5]) / 255;
      var alpha = parseFloat(match[7]);
      var immutableColor = MSImmutableColor.colorWithRed_green_blue_alpha(red, green, blue, alpha);
      if (immutableOnly) {
        return immutableColor;
      }
      // Handle hex colors without a leading # mark.
      return mutableSketchObject(immutableColor);
    }
  }
  // Fall back on black.
  return MSColor.colorWithRed_green_blue_alpha(0, 0, 0, 1);
}

function NSColorFromString(s) {
  return NSColorFromMSColor(MSColorFromString(s));
}

function NSColorFromMSColor(msColor) {
  var h = msColor.hue();
  var s = msColor.saturation();
  var b = msColor.brightness();
  var a = msColor.alpha();
  return NSColor.colorWithCalibratedHue_saturation_brightness_alpha(h, s, b, a);
}

/**
 * end -----------------------------
 * 3、处理颜色相关
 */

/**
 * begin ++++++++++++++++++++++++++++
 * 4、图片文件上传导入
 */

function getTempFilePath(name, ext, ignoreUnique) {
  var fileName = name;

  if (!ignoreUnique) {
    var unique = NSProcessInfo.processInfo().globallyUniqueString();
    fileName = name + '__' + unique;
  }
  if (ext) {
    fileName += '.' + ext;
  }
  return NSTemporaryDirectory().stringByAppendingPathComponent(fileName);
}

function exportLayerToTempFile(document, layer, format) {
  format = format || 'svg';

  var scale = 1; // See also 2X-PNG-ADJUST
  var exportRequest;
  if (MSExportRequest.exportRequestsFromExportableLayer) {
    exportRequest = MSExportRequest.exportRequestsFromExportableLayer(layer)[0];
    exportRequest.setScale(scale);
  } else {
    var rect = layer.absoluteInfluenceRect();
    exportRequest = MSExportRequest.requestWithRect_scale(rect, scale);
    exportRequest.configureForLayer(layer);
  }
  exportRequest.setSaveForWeb(true);

  var tempFilePath = getTempFilePath('Layer-export-' + layer.objectID(), format);
  document.saveArtboardOrSlice_toFile(exportRequest, tempFilePath);

  // return tempFilePath.toString();

  var imageData = NSData.dataWithContentsOfFile(tempFilePath);
  NSFileManager.defaultManager().removeItemAtPath_error(tempFilePath, null);
  return imageData;
}

// function uploadFile(filePath, cb) {
//
//   log("in upload file");
//   log(filePath);
//
//   var kBoundary = "---------------------------198596859919834017191791522499";
//
//   const API_PREFIX = 'https://dsapi.mockplus.cn/v1';
//   var u = API_PREFIX + "/uploadFiles";
//   var url = NSURL.URLWithString(u);
//   var request = NSMutableURLRequest.alloc().init();
//   request.setTimeoutInterval(10);
//   request.setHTTPMethod('POST');
//   request.setURL(url);
//
//   var type = NSString.stringWithFormat("multipart/form-data; boundary=" + kBoundary);
//   request.setValue_forHTTPHeaderField(type, 'Content-Type');
//   request.setValue_forHTTPHeaderField('test', 'X-Auth-Token');
//   var Token = 'R2a1qv94ISC_pWyYnPa5pUsve4E1IjIaPpmbfZ54Du7qV4d-';
//   log(Token);
//   request.setValue_forHTTPHeaderField('Bearer ' + Token, 'Authorization');
//
//   log("set request over");
//
//   var myData = NSMutableData.data();
//
//   var beginStr = "\r\n--" + kBoundary + "\r\n";
//
//   var fileStrM = NSMutableString.alloc().initWithString(beginStr);
//   fileStrM.appendString("Content-Disposition: form-data; name=\"file\"; filename=\"123\"\r\n");
//   fileStrM.appendString("Content-Type: application/octet-stream\r\n\r\n");
//
//   myData.appendData(fileStrM.dataUsingEncoding(NSUTF8StringEncoding));
//   var fileData = NSData.dataWithContentsOfFile(filePath);
//   myData.appendData(fileData);
//
//   // var titleStrM = [[NSMutableString alloc] initWithString:beginStr];
//   // [titleStrM appendString:"Content-Disposition: form-data; name=\"title\"\r\n\r\n"];
//   // [titleStrM appendString:"test\r\n"];
//   // [data appendData:[titleStrM dataUsingEncoding:NSUTF8StringEncoding]];
//   //
//   // var messageStrM = [[NSMutableString alloc] initWithString:beginStr];
//   // [messageStrM appendString:"Content-Disposition: form-data; name=\"message\"\r\n\r\n" ];
//   // [messageStrM appendString:"hello\r\n"];
//   // [data appendData:[messageStrM dataUsingEncoding:NSUTF8StringEncoding]];
//
//   var endStrM = NSString.stringWithFormat("\r\n--" + kBoundary + "--");
//   myData.appendData(endStrM.dataUsingEncoding(NSUTF8StringEncoding));
//
//   request.setHTTPBody(myData);
//
//   log("set data over");
//
//   // var error = MOPointer.alloc().init();
//   // var response = MOPointer.alloc().init();
//   var error = NSError.new();
//   var responseCode = null;
//   log("=================");
//   var d = NSURLConnection.sendSynchronousRequest_returningResponse_error(request, responseCode, error);
//   if(!d) {
//     log("上传文件失败！");
//     return;
//   }
//
//   var string = NSString.alloc().initWithData_encoding(d, NSUTF8StringEncoding);
//   log(string);
//   cb(filterNetError(string));
// }

// function filterNetError(responseStr) {
//   var response = {};
//   try {
//     response = JSON.parse(responseStr);
//   } catch(e) {
//     log("网络请求异常");
//     response.code = "-1";
//     response.message = "网络请求异常";
//   }
//   return response;
// }

//
// //根据扩展名分别使用不同的importor导入数据生成一个sketch图层
// function importImage(urlString, fileExt) {
//   var importer;
//
//   switch (fileExt) {
//     case 'svg':
//       importer = MSSVGImporter.new();
//       break;
//
//     case 'eps':
//     case 'ai':
//       importer = MSPDFImporter.epsImporter();
//       break;
//     case 'jpg':
//     case 'jpeg':
//     case 'png':
//       importer = new BitmapImporter();
//       break;
//     default:
//       importer = new BitmapImporter();
//       break;
//   }
//
//   if (importer) {
//     var data = dataFromURL(urlString);
//     if (data) {
//       importer.prepareToImportFromData(data);
//       return importer.importAsLayer();
//     }
//     return null;
//   } else {
//     debug("No importer for image with \"" + fileExt + "\" extension");
//     return null;
//   }
// }
//
// //通过url字符串获取图片数据
// function dataFromURL(urlString) {
//   var imgData;
//   const url = NSURL.URLWithString(urlString);
//   const webView = persist.get('brandaiMainWebView');
//
//   if (webView) {
//     var resource = webView.mainFrame().dataSource().subresourceForURL(url);
//     if (resource) {
//       debug("Loading image data from web view data source (" + urlString + ")");
//       imgData = resource.data();
//     } else {
//       var cached = webView.windowScriptObject().evaluateWebScript(
//         "window.brandai['imageCache-" + urlString + "']"
//       );
//       if (cached.class() != WebUndefined) {
//         debug("Loading image data from web view custom cache (" + urlString + ")");
//         imgData = NSData.dataWithContentsOfURL(NSURL.URLWithString(cached));
//       }
//     }
//   }
//
//   if (!imgData) {
//     debug('Did not find the url in the image cache. url:' + urlString);
//     logMessage('error', {message: 'Did not find the url in the image cache.', url: urlString });
//   }
//
//   return imgData;
// }

function BitmapImporter() {}

BitmapImporter.prototype.prepareToImportFromData = function (imageData) {
  this.imageData = imageData;
};

BitmapImporter.prototype.importAsLayer = function () {
  var image = NSImage.alloc().initWithData(this.imageData);
  return MSBitmapLayer.bitmapLayerFromImage_withSizeScaledDownByFactor(image, 1);
};

/**
 * end -----------------------------
 * 4、图片文件上传导入
 */

//获取layer的base64编码
function getLayerData(layer) {
  if (layer) {
    var _document3 = MSDocument.currentDocument();

    var archiveOptions = { includeDependencies: true, document: _document3 };

    var archiveData;

    //暂时不考虑母版、引用、依赖等，仅仅转换组件数据
    archiveData = archive.archiveDataFromSketchObject(layer, archiveOptions);
    var archiveDataURL = dataURLFromData(archiveData, 'application/x-skla');
    return archiveDataURL + '';
  } else {
    return '';
  }
};

function dataURLFromData(data, type) {
  return NSString.stringWithFormat('data:%@;base64,%@', type, data.base64EncodedStringWithOptions(0));
}

function loadSketchLayers(data) {

  var archiveData = null;
  var sketchObj = null;

  if (data.layerData) {
    var dataStr = NSString.stringWithFormat(data.layerData);
    archiveData = dataStr.dataUsingEncoding(NSUTF8StringEncoding);
  } else if (data.fileURL) {
    var url = NSURL.URLWithString(data.fileURL);
    archiveData = NSData.alloc().initWithContentsOfURL(url);
  }

  if (archiveData) {
    sketchObj = archive.sketchObjectFromArchiveData(archiveData);
  }

  if (sketchObj) {
    if (sketchObj['class']().dictionary) {
      log('...data is a dictionary');

      var pasteboardLayers = MSPasteboardLayers['new']();

      pasteboardLayers.setLayers(MSLayerArray.arrayWithLayers(arrayWithMutableSketchObjects(archive.sketchObjectFromArchiveData(sketchObj.objectForKey('layers')))));

      (pasteboardLayers.setSymbols || pasteboardLayers.setLocalSymbols)(dictionaryWithMutableSketchObjects(archive.sketchObjectFromArchiveData(sketchObj.objectForKey('symbols'))));

      //todo: need to understand if this need to change
      var sharedObjects = sketchObj.objectForKey('sharedObjects');

      if (sharedObjects) {
        pasteboardLayers.setSharedObjects(dictionaryWithMutableSketchObjects(sharedObjects));
      }

      return pasteboardLayers;
    } else {
      debug('...data is NOT a dictionary, assume it is layers');
      var layer = mutableSketchObject(sketchObj);
      layer.setObjectID(null);
      if (layer['class']() == 'MSSymbolMaster') {
        // Symbol masters are a special case because what we want to “paste” is
        // an instance of the master, not the master itself.
        return pasteboardLayersFromSymbolMaster(layer);
      } else {

        var _pasteboardLayers = MSPasteboardLayers['new']();
        _pasteboardLayers.setLayers(MSLayerArray.arrayWithLayers([layer]));
        return _pasteboardLayers;
      }
    }
  } else {}
}

function pasteboardLayersFromSymbolMaster(symbolMaster) {
  var pboardLayers = MSPasteboardLayers['new']();
  var symbols = NSMutableDictionary.dictionaryWithCapacity(1);
  symbols.setObject_forKey(symbolMaster, symbolMaster.symbolID());
  (pboardLayers.setSymbols || pboardLayers.setLocalSymbols)(symbols);
  pboardLayers.setLayers(MSLayerArray.arrayWithLayer(symbolMaster.newSymbolInstance()));
  return pboardLayers;
}

// Convert any immutable Sketch objects to mutable.
function arrayWithMutableSketchObjects(array) {
  return $.map(array, function (object) {
    if (isImmutableSketchObject(object)) {
      return mutableSketchObject(object);
    } else {
      return object;
    }
  });
}

// Convert any immutable Sketch objects to mutable.
function dictionaryWithMutableSketchObjects(dictionary) {
  return $.mapObject(dictionary.allKeys(), function (key) {
    var object = dictionary.objectForKey(key);
    if (object['class']().dictionary) {
      return [key, dictionaryWithMutableSketchObjects(object)];
    } else if (isImmutableSketchObject(object)) {
      return [key, mutableSketchObject(object)];
    } else {
      return [key, object];
    }
  });
}

function isImmutableSketchObject(sketchObject) {
  return !!(sketchObject && sketchObject['class']().mutableClass && sketchObject['class']().mutableClass() && sketchObject['class']().mutableClass() !== sketchObject['class']());
}

//通过url字符串获取图片数据
function dataFromURL(urlString) {
  var imgData;
  var url = NSURL.URLWithString(urlString);

  if (webView) {
    var resource = webView.mainFrame().dataSource().subresourceForURL(url);
    if (resource) {
      imgData = resource.data();
    } else {}
  }

  if (!imgData) {}

  return imgData;
}

/**
 * begin ++++++++++++++++++++++++++++
 * 5、工具类函数
 */

//获取文档中被选中的layers
function selectedLayersInDocument(document) {
  var selectedLayers = document.selectedLayers();
  if (selectedLayers['class']() == 'MSLayerArray') {
    return selectedLayers.containedLayers();
  } else {
    return selectedLayers;
  }
}

//获取给定layer的父layer
function getParentLayer(layer, parentClass) {
  // Default to any MSLayer.
  parentClass = parentClass || MSLayer;

  return layer.ancestors().reverseObjectEnumerator().allObjects().find(function (ancestor) {
    // Some versions of Sketch return ancestors() with the layer itself in the
    // list of ancestors, so we have to check that the ancestor is not the
    // input layer.
    return ancestor['class']().isSubclassOfClass(parentClass) && ancestor !== layer;
  });
}

function getStyleById(collection, id) {
  return collection.find(function (style) {
    return style.objectID().isEqualToString(id);
  });
}

function coerceString(str) {
  if (str) {
    return '' + str;
  } else {
    return null;
  }
}

function coerceBool(number) {
  // eslint-disable-line no-unused-vars
  return !!(number + 0);
}

//弹出苹果默认对话框，可以输入文本
function displayPrompt(options) {
  var buttons = options.buttons || ['OK'];

  var alert = NSAlert['new']();
  alert.setMessageText(options.title);

  if (options.description) {
    alert.setInformativeText(options.description);
  }

  buttons.forEach(function (button) {
    alert.addButtonWithTitle(button);
  });

  var textField;
  if (options.multiline) {
    textField = NSTextView.alloc().initWithFrame(NSMakeRect(0, 0, 295, 40));
    textField.scrollEnabled = true;
    textField.showsVerticalScrollIndicator = true;
    textField.text = options.defaultText || '';
  } else {
    textField = NSTextField.alloc().initWithFrame(NSMakeRect(0, 0, 295, 22));
    textField.setStringValue(options.defaultText || '');
  }

  textField.setEditable(true);
  alert.setAccessoryView(textField);
  alert.window().setInitialFirstResponder(textField);

  if (alert.runModal() == 1000) {
    var text = textField['class']() == 'NSTextView' ? textField.string() : textField.stringValue();
    return coerceString(text);
  } else {
    return null;
  }
}

function mutableSketchObject(immutableSketchObject) {
  if (immutableSketchObject && immutableSketchObject['class']) {
    var immutableClass = immutableSketchObject['class']();
    if (immutableClass.mutableClass) {
      var mutableClass = immutableClass.mutableClass();
      return mutableClass['new']().initWithImmutableModelObject(immutableSketchObject);
    }
  }
}

function convertTextAlign(align) {

  var result = Text.Alignment.left;
  if (align === 'left') {
    result = Text.Alignment.left;
  } else if (align === 'center') {
    result = Text.Alignment.center;
  } else if (align === 'right') {
    result = Text.Alignment.right;
  }
  return result;
}

function isEmptyLocalData(value) {
  return value === undefined || value === '' || value === 'null';
}

/**
 * end -----------------------------
 * 5、工具类函数
 */

/***/ }),
/* 3 */
/***/ (function(module, exports) {

module.exports = require("sketch");

/***/ }),
/* 4 */
/***/ (function(module, exports) {

module.exports = require("sketch/ui");

/***/ }),
/* 5 */
/***/ (function(module, exports) {

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

module.exports = function (selectorHandlerDict) {
  var uniqueClassName = "MochaJSDelegate_DynamicClass_" + NSUUID.UUID().UUIDString();

  var delegateClassDesc = MOClassDescription.allocateDescriptionForClassWithName_superclass_(uniqueClassName, NSObject);

  delegateClassDesc.registerClass();

  //  Handler storage

  var handlers = {};

  //  Define interface

  this.setHandlerForSelector = function (selectorString, func) {
    var handlerHasBeenSet = selectorString in handlers;
    var selector = NSSelectorFromString(selectorString);

    handlers[selectorString] = func;

    if (!handlerHasBeenSet) {
      /*
        For some reason, Mocha acts weird about arguments:
        https://github.com/logancollins/Mocha/issues/28
         We have to basically create a dynamic handler with a likewise dynamic number of predefined arguments.
      */

      var dynamicHandler = function dynamicHandler() {
        var functionToCall = handlers[selectorString];

        if (!functionToCall) return;

        return functionToCall.apply(delegateClassDesc, arguments);
      };

      var args = [],
          regex = /:/g;
      while (match = regex.exec(selectorString)) {
        args.push("arg" + args.length);
      }dynamicFunction = eval("(function(" + args.join(",") + "){ return dynamicHandler.apply(this, arguments); })");

      delegateClassDesc.addInstanceMethodWithSelector_function_(selector, dynamicFunction);
    }
  };

  this.removeHandlerForSelector = function (selectorString) {
    delete handlers[selectorString];
  };

  this.getHandlerForSelector = function (selectorString) {
    return handlers[selectorString];
  };

  this.getAllHandlers = function () {
    return handlers;
  };

  this.getClass = function () {
    return NSClassFromString(uniqueClassName);
  };

  this.getClassInstance = function () {
    return NSClassFromString(uniqueClassName)["new"]();
  };

  //  Conveience

  if ((typeof selectorHandlerDict === "undefined" ? "undefined" : _typeof(selectorHandlerDict)) == "object") {
    for (var selectorString in selectorHandlerDict) {
      this.setHandlerForSelector(selectorString, selectorHandlerDict[selectorString]);
    }
  }
};

/***/ }),
/* 6 */
/***/ (function(module, exports) {


var persist = { // eslint-disable-line no-unused-vars
  get: function () {
    function get(key) {
      return NSUserDefaults.standardUserDefaults().stringForKey(key) + "";
    }

    return get;
  }(),

  set: function () {
    function set(key, value) {
      NSUserDefaults.standardUserDefaults().setObject_forKey(value, key);
      NSUserDefaults.standardUserDefaults().synchronize();
    }

    return set;
  }(),

  remove: function () {
    function remove(key) {
      NSUserDefaults.standardUserDefaults().removeObjectForKey(key);
      NSUserDefaults.standardUserDefaults().synchronize();
    }

    return remove;
  }()
};

module.exports = persist;

/***/ }),
/* 7 */
/***/ (function(module, exports, __webpack_require__) {

/*
  globals
  MSImmutableLayer
  MSJSONDataArchiver
  MSJSONDataUnarchiver
  MSKeyedUnarchiver
  MSLayerArray
  MSPasteboardLayersBase
  MSPasteboardLayersReaderWriter
  NSData
  NSDictionary
  NSMutableDictionary
  NSSet
  NSString
  NSUTF8StringEncoding
  $
  getSymbolsMastersByID
*/

var $ = __webpack_require__(1);

var SKETCH_47_JSON_FORMAT_VERSION = 95;

function archiveDataFromSketchObject(object, options) {
  if (options && options.includeDependencies) {
    if (!options.document) {
      throw 'Options must include "document" when "includeDependencies" is true';
    }
    var documentData = options.document.documentData();
    var reader = MSPasteboardLayersReaderWriter['new']();

    var symbols = null;
    if (reader.usedSymbolsInContainer_document) {
      symbols = reader.usedSymbolsInContainer_document(MSLayerArray.arrayWithLayer(object), documentData);
    } else {
      symbols = MSPasteboardLayersBase.usedSymbolsInContainer_document(MSLayerArray.arrayWithLayer(object), documentData);
    }

    // In Sketch 48 the symbols are returned as a set of
    // ids, but what we need is a map of those ids to the
    // symbols themselves.
    if (symbols['class']().isSubclassOfClass(NSSet)) {
      var symbolsDict = NSMutableDictionary['new']();
      var documentSymbols = getSymbolsMastersByID(options.document);
      $.forEach(symbols.allObjects(), function (symbolID) {
        var symbol = documentSymbols[symbolID].immutableModelObject();
        symbolsDict.setObject_forKey(symbol, symbolID);
      });
      symbols = symbolsDict;
    }

    object = NSDictionary.dictionaryWithDictionary({
      layers: [object.immutableModelObject()],
      symbols: symbols
    });
  }

  var immutableObject = object.immutableModelObject();
  var archiver = MSJSONDataArchiver['new']();
  archiver.setArchiveObjectIDs(true);
  var archiveData = archiver.archivedDataWithRootObject_error(immutableObject, null);

  return wrapArchiveDataInHeader(archiveData);
}

function sketchObjectFromArchiveData(archiveData) {
  log("test0");
  log(archiveData['class']());
  if (archiveData && archiveData['class']().isSubclassOfClass(NSData)) {

    log("test1");
    var jsonString = stringFromData(archiveData);

    log("test2");
    // The default format version to use is the one exported
    // by Sketch 47. This is the last version for which we
    // did not store the format version so we would know
    // what to use when unarchiving. This is not exact
    // because of course customers do not always upgrade at
    // the same time, but because of backwards compatibility
    // going back several format versions, it is fine.
    var formatVersion = SKETCH_47_JSON_FORMAT_VERSION;

    var jsData;
    try {
      jsData = JSON.parse(jsonString);
    } catch (err) {
      jsData = null; // No-op.
    }

    log("test3");
    if (!jsData) {
      // Format is not JSON, use the keyed unarchiver.
      return MSKeyedUnarchiver.unarchiveObjectWithData(archiveData);
    }

    if (jsData._class === 'MSArchiveHeader') {
      // If there is a wrapping header, take the format
      // version from it.
      formatVersion = jsData.version;

      // Also unwrap the archive data from the header
      // because the header throws Sketch off even though it
      // contains the correct version information.
      jsData = jsData.root;
    }

    return sketchObjectFromArchiveJSONUsingFormatVersion(JSON.stringify(jsData), formatVersion);
  } else {
    // Object has already been unarchived.
    return archiveData;
  }
}

function wrapArchiveDataInHeader(archiveData) {
  var archiveJSONString = stringFromData(archiveData);
  var archiveJSData = JSON.parse(archiveJSONString);

  var headerJSData = createArchiveHeaderJSData();
  headerJSData.root = archiveJSData;

  var archiveWithHeaderJSONString = JSON.stringify(headerJSData);
  return dataFromString(archiveWithHeaderJSONString);
}

function createArchiveHeaderJSData() {
  // Creating a header directly with MSArchiveHeader.new()
  // results in a header with no properties --- not what we
  // want. Instead, export a stub object and use the header
  // from that.
  var object = MSImmutableLayer['new']();
  var archiveWithHeaderData = MSJSONDataArchiver.archivedDataWithHeaderAndRootObject(object);
  var archiveWithHeaderJSONString = stringFromData(archiveWithHeaderData);
  var archiveWithHeaderJSData = JSON.parse(archiveWithHeaderJSONString);
  delete archiveWithHeaderJSData.root;
  return archiveWithHeaderJSData;
}

// Unarchive with a known version of the JSON format.
function sketchObjectFromArchiveJSONUsingFormatVersion(jsonString, formatVersion) {
  return MSJSONDataUnarchiver.unarchiveObjectWithString_asVersion_corruptionDetected_error(jsonString, formatVersion, null, null);
}

function stringFromData(data) {
  return NSString.alloc().initWithData_encoding(data, NSUTF8StringEncoding);
}

function dataFromString(string) {
  return NSString.stringWithString(string).dataUsingEncoding(NSUTF8StringEncoding);
}

function getSymbolsMastersByID(document) {
  var documentSymbols = {};
  var symbols = document.documentData().allSymbols();
  $.forEach(symbols, function (symbol) {
    documentSymbols[symbol.symbolID()] = symbol;
  });
  return documentSymbols;
}

module.exports = {
  archiveDataFromSketchObject: archiveDataFromSketchObject,
  sketchObjectFromArchiveData: sketchObjectFromArchiveData
};

/***/ }),
/* 8 */
/***/ (function(module, exports, __webpack_require__) {

/* globals NSUUID NSThread NSPanel NSMakeRect NSTexturedBackgroundWindowMask NSTitledWindowMask NSWindowTitleHidden NSClosableWindowMask NSColor NSWindowMiniaturizeButton NSWindowZoomButton NSFloatingWindowLevel WebView COScript NSWindowCloseButton NSFullSizeContentViewWindowMask NSVisualEffectView NSAppearance NSAppearanceNameVibrantLight NSVisualEffectBlendingModeBehindWindow NSLayoutConstraint NSLayoutRelationEqual NSLayoutAttributeLeft NSLayoutAttributeTop NSLayoutAttributeRight NSLayoutAttributeBottom NSResizableWindowMask */
var MochaJSDelegate = __webpack_require__(9);

var coScript = COScript.currentCOScript();

var LOCATION_CHANGED = 'webView:didChangeLocationWithinPageForFrame:';

function addEdgeConstraint(edge, subview, view, constant) {
  view.addConstraint(NSLayoutConstraint.constraintWithItem_attribute_relatedBy_toItem_attribute_multiplier_constant(subview, edge, NSLayoutRelationEqual, view, edge, 1, constant));
}
function fitSubviewToView(subview, view, constants) {
  subview.setTranslatesAutoresizingMaskIntoConstraints(false);

  addEdgeConstraint(NSLayoutAttributeLeft, subview, view, constants[0]);
  addEdgeConstraint(NSLayoutAttributeTop, subview, view, constants[1]);
  addEdgeConstraint(NSLayoutAttributeRight, subview, view, constants[2]);
  addEdgeConstraint(NSLayoutAttributeBottom, subview, view, constants[3]);
}

function WebUI(context, frameLocation, options) {
  options = options || {};
  var identifier = options.identifier || NSUUID.UUID().UUIDString();
  var threadDictionary = NSThread.mainThread().threadDictionary();

  var panel;
  var webView;

  function closeHandler() {
    if (options.onPanelClose) {
      var result = options.onPanelClose();
      if (result === false) {
        return;
      }
    }

    panel.isOpened = false;
    panel.close();
    if (threadDictionary[identifier]) {
      threadDictionary.removeObjectForKey(identifier);
    }
  }

  panel = NSPanel.alloc().init();
  panel.isOpened = true;

  // Window size
  var panelWidth = options.width || 240;
  var panelHeight = options.height || 180;
  panel.setFrame_display(NSMakeRect(options.x || 0, options.y || 0, panelWidth, panelHeight), true);

  // Titlebar
  panel.setTitle(options.title || context.plugin.name());
  if (options.hideTitleBar) {
    panel.title = "";
  }

  // Hide minize and zoom buttons
  if (options.onlyShowCloseButton) {
    panel.standardWindowButton(NSWindowMiniaturizeButton).setHidden(true);
    panel.standardWindowButton(NSWindowZoomButton).setHidden(true);
  }

  // Close window callback
  var closeButton = panel.standardWindowButton(NSWindowCloseButton);

  closeButton.setCOSJSTargetFunction(closeHandler);
  closeButton.setAction('callAction:');

  panel.setStyleMask(options.styleMask || (options.resizable ? NSTexturedBackgroundWindowMask | NSTitledWindowMask | NSResizableWindowMask | NSClosableWindowMask | NSFullSizeContentViewWindowMask : NSTexturedBackgroundWindowMask | NSTitledWindowMask | NSClosableWindowMask | NSFullSizeContentViewWindowMask));

  panel.becomeKeyWindow();
  panel.setLevel(NSFloatingWindowLevel);

  // Appearance
  var backgroundColor = options.background || NSColor.whiteColor();
  panel.setBackgroundColor(backgroundColor);
  if (options.blurredBackground) {
    var vibrancy = NSVisualEffectView.alloc().initWithFrame(NSMakeRect(0, 0, panelWidth, panelHeight));
    vibrancy.setAppearance(NSAppearance.appearanceNamed(NSAppearanceNameVibrantLight));
    vibrancy.setBlendingMode(NSVisualEffectBlendingModeBehindWindow);

    // Add it to the panel
    panel.contentView().addSubview(vibrancy);
    fitSubviewToView(vibrancy, panel.contentView(), [0, 0, 0, 0]);
  }

  if (options.shouldKeepAround !== false) {
    // Long-running script
    coScript.setShouldKeepAround(true);
  }

  // Add Web View to window
  webView = WebView.alloc().initWithFrame(NSMakeRect(0, 0, options.width || 240, (options.height || 180) - 44));

  threadDictionary[identifier] = {
    panel: panel,
    eval: webView.stringByEvaluatingJavaScriptFromString,
    webView: webView,
    close: closeHandler
  };

  if (options.frameLoadDelegate || options.handlers) {
    var handlers = options.handlers || {};
    var frameLoadDelegate = new MochaJSDelegate(handlers);
    webView.setFrameLoadDelegate_(frameLoadDelegate.getClassInstance());
  }
  if (options.uiDelegate) {
    var uiDelegate = new MochaJSDelegate(options.uiDelegate);
    webView.setUIDelegate_(uiDelegate.getClassInstance());
  }

  if (!options.blurredBackground) {
    webView.setOpaque(true);
    webView.setBackgroundColor(backgroundColor);
  } else {
    // Prevent it from drawing a white background
    webView.setDrawsBackground(false);
  }

  log(frameLocation);
  webView.setMainFrameURL_(frameLocation);

  panel.contentView().addSubview(webView);

  panel.center();
  panel.makeKeyAndOrderFront(null);

  return {
    panel: panel,
    eval: webView.stringByEvaluatingJavaScriptFromString,
    webView: webView,
    close: closeHandler
  };
}

module.exports = WebUI;

/***/ }),
/* 9 */
/***/ (function(module, exports) {

/* globals NSUUID MOClassDescription NSObject NSSelectorFromString NSClassFromString */

module.exports = function (selectorHandlerDict, superclass) {
  var uniqueClassName = 'MochaJSDelegate_DynamicClass_' + NSUUID.UUID().UUIDString()

  var delegateClassDesc = MOClassDescription.allocateDescriptionForClassWithName_superclass_(uniqueClassName, superclass || NSObject)

  delegateClassDesc.registerClass()

  // Storage Handlers
  var handlers = {}

  // Define interface
  this.setHandlerForSelector = function (selectorString, func) {
    var handlerHasBeenSet = (selectorString in handlers)
    var selector = NSSelectorFromString(selectorString)

    handlers[selectorString] = func

    /*
      For some reason, Mocha acts weird about arguments: https://github.com/logancollins/Mocha/issues/28
      We have to basically create a dynamic handler with a likewise dynamic number of predefined arguments.
    */
    if (!handlerHasBeenSet) {
      var args = []
      var regex = /:/g
      while (regex.exec(selectorString)) {
        args.push('arg' + args.length)
      }

      var dynamicFunction = eval('(function (' + args.join(', ') + ') { return handlers[selectorString].apply(this, arguments); })')

      delegateClassDesc.addInstanceMethodWithSelector_function_(selector, dynamicFunction)
    }
  }

  this.removeHandlerForSelector = function (selectorString) {
    delete handlers[selectorString]
  }

  this.getHandlerForSelector = function (selectorString) {
    return handlers[selectorString]
  }

  this.getAllHandlers = function () {
    return handlers
  }

  this.getClass = function () {
    return NSClassFromString(uniqueClassName)
  }

  this.getClassInstance = function () {
    return NSClassFromString(uniqueClassName).new()
  }

  // Convenience
  if (typeof selectorHandlerDict === 'object') {
    for (var selectorString in selectorHandlerDict) {
      this.setHandlerForSelector(selectorString, selectorHandlerDict[selectorString])
    }
  }
}


/***/ })
/******/ ]);
  if (key === 'default' && typeof exports === 'function') {
    exports(context);
  } else {
    exports[key](context);
  }
}
that['onRun'] = __skpm_run.bind(this, 'default')
